from django.db import models

# Create your models here.


class Account(models.Model):
	class Meta:
		db_table = 'accounts'

	primary = models.ForeignKey('Employee', blank=True, null=True)
	pass


class Contact(models.Model):
	class Meta:
		db_table = 'contacts'
	pass


class Company(Account, Contact):
	class Meta:
		db_table = 'companies'
	label = models.CharField(max_length=32)
	pass


class Person(Contact):
	class Meta:
		db_table = 'persons'

	first_name = models.CharField(max_length=32)
	last_name = models.CharField(max_length=32)
	pass


class Employee(Person):
	class Meta:
		db_table = 'employees'

	company = models.ForeignKey('Company')
	pass