# django imports
from django.conf import settings
from django.db import connection
from django.test import TestCase

# app imports
from minherit.data.models import Company
from minherit.data.models import Contact
from minherit.data.models import Employee
from minherit.data.models import Person


class CompanyEmployeeTest(TestCase):
	
    def test_insert_1(self):
        '''
        fails with postgresql_psycopg2
        '''
        settings.DEBUG = True

        c = Company( label = 'OmniCorp' )
        c.save()

        print '*' * 80 ; print
        for q in connection.queries:
            print q['sql'] ; print
        print '*' * 80 ; print

        e = Employee( first_name = 'Tim', last_name = 'Dildarian', company = c )
        e.save()

        print '*' * 80 ; print
        for q in connection.queries:
            print q['sql'] ; print
        print '*' * 80 ; print
        connection.queries = []

        self.assertTrue(c)
        self.assertTrue(e)
        self.assertEqual(2, Contact.objects.count())
        return


    def test_insert_2(self):
        '''
        fails with postgresql_psycopg2
        '''
        settings.DEBUG = True

        p = Person( first_name = 'Tim', last_name = 'Dildarian' )
        p.save()

        print '*' * 80 ; print
        for q in connection.queries:
            print q['sql'] ; print
        print '*' * 80 ; print
        connection.queries = []

        c = Company( label = 'LSoft' )
        c.save()

        print '*' * 80 ; print
        for q in connection.queries:
            print q['sql'] ; print
        print '*' * 80 ; print

        self.assertTrue(p)
        self.assertTrue(c)
        self.assertEqual(2, Contact.objects.count())
        return
