from django.db import models

# Create your models here.


class Labelled(models.Model):
	class Meta:
		abstract = True
		app_label = 'data'

	label = models.CharField(max_length=256)

	def __unicode__(self):
		return self.label
	pass


class Reviseable(models.Model):
	class Meta:
		abstract = True

	revision = models.PositiveIntegerField(default=0, editable=False )
	pass


class Account(Reviseable):
	class Meta:
		db_table = 'accounts'

	primary = models.ForeignKey('Employee', blank=True, null=True)
	pass


class Contact(Labelled):
	class Meta:
		db_table = 'contacts'
	pass


class Company(Account, Contact):
	class Meta:
		app_label = 'data'
		db_table = 'companies'
	pass



class Person(Reviseable, Contact):
	class Meta:
		db_table = 'persons'

	first_name = models.CharField(max_length=32)
	last_name = models.CharField(max_length=32)
	pass


class Employee(Person):
	class Meta:
		db_table = 'employees'

	company = models.ForeignKey('Company')
	pass