from django.contrib.auth.models import User
from django.contrib.gis.db import models as geomodels
from django.db import models
from django.test import TestCase


class GeoModel(geomodels.Model):
    user = geomodels.ForeignKey(User, unique=True)
    objects = geomodels.GeoManager()


class Model(models.Model):
    geomodel = models.ForeignKey(GeoModel, unique=True)
    objects = geomodels.GeoManager()


class Test(TestCase):
    def setUp(self):
        user = User.objects.create_user('test', 'test@example.com', 'test')
	geomodel = GeoModel.objects.create(user=user)
	self.model = Model.objects.create(geomodel=geomodel)

    def test_select_related(self):
        models = Model.objects.select_related('geomodel__model').all()
	self.assertEqual(list(models), [self.model])
