#!/usr/bin/env python
import re
import logging

from urlparse import urlparse

import django.http
from django.conf import settings

class HttpResponseSafeRedirect(django.http.HttpResponse):
    status_code = 302

    def __init__(self, redirect_to, whitelist=[], fallback_to=None):
        django.http.HttpResponse.__init__(self)

        self['Location'] = redirect_to

        if urlparse(self['Location']).scheme:
            effective_whitelist = set(whitelist + getattr(settings, 'REDIRECT_WHITELIST', []))

            matched = False

            for pattern in effective_whitelist:
                matched = re.compile(pattern).match(self['Location'])

                if matched:
                    break

            if not matched:
                logging.warn("found open redirect attack to %s", self['Location'])

                self['Location'] = fallback_to or settings.LOGIN_REDIRECT_URL

def hack_django(cls, *args, **kwds):
    if hasattr(settings, 'REDIRECT_WHITELIST'):
        return HttpResponseSafeRedirect(*args, **kwds)
    else:
        print "WARN: Use REDIRECT_WHITELIST setting and protect your end user " \
              "from the open redirect vulnerability. <http://www.owasp.org/index.php/Open_redirect>"

        return object.__new__(cls, *args, **kwds)

django.http.HttpResponseRedirect.__new__ = staticmethod(hack_django)
