#!/usr/bin/env python
import re
import logging

from urlparse import urlparse

import django.http 
from django.conf import settings

class HttpResponseSafeRedirect(django.http.HttpResponse):
    status_code = 302
    
    def __init__(self, redirect_to, whitelist=[], fallback_to=None):
        django.http.HttpResponse.__init__(self)
        
        self['Location'] = redirect_to
    
        if urlparse(self['Location']).scheme:
            matched = False
            
            for pattern in whitelist:
                if hasattr(pattern, 'match'):
                    matched = pattern.match(self['Location'])
                    break
                else:
                    matched = self['Location'].startswith(pattern)
                    break
            
            if not matched:
                logging.warn("found open redirect attack to %s", self['Location'])
                
                self['Location'] = fallback_to or settings.LOGIN_REDIRECT_URL

django.http.HttpResponseRedirect = HttpResponseSafeRedirect