"""
Test for ticket #13679
"""

from django.test import TestCase
from django.forms import ModelForm

from modelform.testing.models import MainModel, RelatedModel


class ModelFormTest(TestCase):
    def testForm(self):
        """
        Tests that ModelForm renders with a the default value for a
        ForeignKey selected.
        """
        RelatedModel(name="not default").save()
        RelatedModel(name="default").save()

        class TestForm(ModelForm):
            class Meta:
                model = MainModel

        form = TestForm()
        rendered = form.as_p()
        correct = u'<p><label for="id_choice">Choice:</label> <select name="choice" id="id_choice">\n<option value="1">not default</option>\n<option value="2" selected="selected">default</option>\n</select><input type="hidden" name="initial-choice" value="2" id="id_choice" /></p>'
        self.failUnlessEqual(rendered, correct)
