class DatabaseRouter(object):

    # We are not implementing db_for_read nor db_for_write because we don't
    # want to bind models to a specific database. We use database sharding
    # and we save data either to "test1" or "test2" database depending on some
    # extenrnal conditions.

    def allow_syncdb(self, db, model):

        if model._meta.app_label == "test_app" and db == "test1":
            return True
        if model._meta.app_label == "test_app" and db == "test2":
            return True

        # Additional conditions goes here. Lets pretend that the "default"
        # database is used by some other application.
        return False
