from django.utils.cache import patch_vary_headers
from django.utils import translation
from blog import settings

class LocaleURLMiddleware:
    def get_language_from_request (self,request):
        from django.conf import settings
        import re
        supported = dict(settings.LANGUAGES)
        lang = settings.LANGUAGE_CODE[:2]
        check = re.match(r'/(\w\w)/.*', request.path)
        changed = False
        if check is not None:
            t = check.group(1)
            if t in supported:
                lang = t
                if hasattr(request, 'session'):
                    request.session['django_language'] = lang
                else:
                    response.set_cookie('django_language', lang)
                changed = True
        if not changed:
            if hasattr(request, 'session'):
                lang = request.session.get('django_language', None)
                if lang in supported and lang is not None:
                    return lang
            else:
                lang = request.COOKIES.get('django_language', None)
                if lang in supported and lang is not None:
                    return lang
        return lang
    def process_request(self, request):
        from django.conf import settings
        language = self.get_language_from_request(request)
        if language is None:
            language = settings.LANGUAGE_CODE[:2]
        translation.activate(language)
        request.LANGUAGE_CODE = translation.get_language()
    def process_response(self, request, response):
        patch_vary_headers(response, ('Accept-Language',))
        translation.deactivate()
        return response

def get_absolute_path_without_lang(request):
    for lang in settings.LANGUAGES:
        if '' + str(lang[0]) + '' in request.path:
            return request.path.replace('/' + str(lang[0]) + '', '')
    return request.path
