from django.db import models

# Create your models here.
class Author(models.Model):
    name = models.CharField(max_length=100)
    
class Book(models.Model):
    name = models.CharField(max_length=300)
    author = models.ForeignKey(Author)
    price = models.DecimalField(max_digits=10, decimal_places=2)

class Publication(models.Model):
    book = models.ForeignKey("Book")
    date = models.DateField()

class Review(models.Model):
    book = models.ForeignKey("Book")
    date = models.DateField(null=True)
