"""
This file demonstrates two different styles of tests (one doctest and one
unittest). These will both pass when you run "manage.py test".

Replace these with more appropriate tests for your application.
"""

from django.test import TestCase
from models import *
from django.db.models import Q, Max
import datetime

class SimpleTest(TestCase):
    def test_aggregatebug(self):
        king = Author(name="King"); king.save()
        sartre = Author(name="Sartre"); sartre.save()
        it = Book(name="It", author=king, price=10); it.save()
        lemur = Book(name="Le mur", author=sartre, price=20); lemur.save()

        it.publication_set.add(Publication(date='1970-01-01'))
        it.review_set.add(Review(date='1970-01-01'))
        lemur.publication_set.add(Publication(date='1970-01-01'))
        # no review, should still be marked as inactive

        today = datetime.date.today()
        tree_months_ago = today - datetime.timedelta(days=3*31)
        # Let's check books with no review for the past 3 months (if
        # they were published more than 3 months ago):
        inactive_books_qs = Book.objects \
            .annotate(last_review_date=Max('review__date')) \
            .annotate(last_publication_date=Max('publication__date')) \
            .filter(last_publication_date__lt=tree_months_ago) \
            .filter(Q(last_review_date__lt=tree_months_ago)|Q(last_review_date__isnull=True)) \
            .only('id')
        print inactive_books_qs.query
        # Issues:
        # - parenthesis not closed after 'MAX("aggregatebug_publication"."date") < 2010-01-21'
        # - AND instead of OR!!!
        #   MAX("aggregatebug_review"."date") < 2010-01-21  AND MAX("aggregatebug_review"."date") IS NULL
        # - no parenthesis around the test above

        self.failUnlessEqual(inactive_books_qs.count(), 2)
