from django.db import models

class LiveEntryManager(models.Manager):
    def get_query_set(self):
        return super(LiveEntryManager, self).get_query_set().filter(
            release_date__lte=datetime.datetime.now(),
            status=Entry.STATUS_LIVE
            )

class Entry(models.Model):
    STATUS_DRAFT = 1
    STATUS_QUEUED = 2
    STATUS_LIVE = 3

    ENTRY_STATUS_CHOICES = (
        (STATUS_DRAFT,  "Draft"),
        (STATUS_QUEUED, "Queued"),
        (STATUS_LIVE,   "Live"),
    )
    
    release_date = models.DateTimeField(
        blank=True,
        db_index=True,
        default=datetime.datetime.now,
        editable=True,
        help_text="Don't change this after publishing; it breaks URLs."
    )
    status = models.PositiveSmallIntegerField(choices=ENTRY_STATUS_CHOICES)
    
    live = LiveEntryManager()
