from django.test import TestCase

from django.db.models import Q
from sandbox.q.models import CarVendor, CarModel, Car


class SimpleTest(TestCase):
    def test_exclude_1(self):
        """
        Tests that .exclude([...]) and .exclude(Q([...])) return the same
        """
        v = CarVendor(name="BMW")
        v.save()
        m = CarModel(name="330i", car_vendor=v)
        m.save()
        c = Car(owner="Bob Miller", car_model=m)
        c.save()
        v = CarVendor(name="Ford")
        v.save()
        m = CarModel(name="Mustang Shelby", car_vendor=v)
        m.save()
        c = Car(owner="Kevin Smith", car_model=m)
        c.save()
        self.failUnlessEqual(
            str(Car.objects.exclude(  car_model__car_vendor__name="BMW" )),
            str(Car.objects.exclude(Q(car_model__car_vendor__name="BMW")))
            )

    def test_exclude_2(self):
        """
        Tests that .exclude([...]) and .exclude(Q([...])) return the same
        when one of the related objects contains a NULL field.
        """
        v = CarVendor(name="BMW")
        v.save()
        m = CarModel(name="330i", car_vendor=v)
        m.save()
        c = Car(owner="Bob Miller", car_model=m)
        c.save()
        m = CarModel(name="Mustang Shelby") # This car model has no vendor (vendor == NULL, which is allowed by the model)
        m.save()
        c = Car(owner="Kevin Smith", car_model=m)
        c.save()
        self.failUnlessEqual(
            str(Car.objects.exclude(  car_model__car_vendor__name="BMW" )),
            str(Car.objects.exclude(Q(car_model__car_vendor__name="BMW")))
            )
