from django.db import models

class CarVendor(models.Model):
    name = models.CharField(max_length=128)
    def __unicode__(self):
        return u'%s' % self.name

class CarModel(models.Model):
    name = models.CharField(max_length=128)
    car_vendor = models.ForeignKey(CarVendor, blank=True, null=True)
    def __unicode__(self):
        return u'%s %s' % (self.name, self.car_vendor)

class Car(models.Model):
    owner = models.CharField(max_length=128)
    car_model = models.ForeignKey(CarModel)
    def __unicode__(self):
        return u'%s %s' % (self.owner, self.car_model)
