from django.conf import settings
settings.configure(
    DATABASE_ENGINE = 'sqlite3',
    DATABASE_NAME = ':memory:',
    installed_apps = ('test_form',),
    DEBUG = True
)

from django.db import models
from django.core import exceptions
from django import forms

import unittest

class CoreValidationError(Exception):
    """
    
    The "inner" python type doesn't need to know about django at all, so we pretend,
    that a different exception is raised
    """
    pass

class TestType(object):

    def __init__(self, text):
        if text != 'foo':
            raise CoreValidationError('The value must be "foo", received "%s"' % text)
        self.data = text

class TestFieldSubfieldBase(models.Field):
    __metaclass__ = models.SubfieldBase
    
    def __init__(self, *args, **kwargs):
        super(TestFieldSubfieldBase, self).__init__(*args, **kwargs)
    
    def to_python(self, value):
        if isinstance(value, TestType):
            return value
        if value is None or value == '':
            return None
        try:
            return TestType(value)
        except CoreValidationError, e:
            raise exceptions.ValidationError(str(e))

class TestField(models.Field):
    
    def __init__(self, *args, **kwargs):
        super(TestField, self).__init__(*args, **kwargs)
    
    def to_python(self, value):
        if isinstance(value, TestType):
            return value
        if value is None or value == '':
            return None
        try:
            return TestType(value)
        except CoreValidationError, e:
            raise exceptions.ValidationError(str(e))

class MyModel(models.Model):
    
    class Meta:
        app_label = 'test_form'
    
    field_with_subfieldbase = TestFieldSubfieldBase(blank=True)
    field_without_subfieldbase = TestField(blank=True)

    
class MyForm(forms.ModelForm):
    
    class Meta:
        model = MyModel


class TestValidation(unittest.TestCase):
        
    def test_valid_value_with_subfieldbase(self):
        form = MyForm(data={u'field_with_subfieldbase':u'foo'})
        print form.errors
        self.assertTrue(form.is_valid())
    
    def test_invalid_value_with_subfieldbase(self):
        form = MyForm(data={u'field_with_subfieldbase':u'bar'})
        self.assertFalse(form.is_valid())
    
    def test_valid_value_without_subfieldbase(self):
        form = MyForm(data={u'field_without_subfieldbase':u'foo'})
        self.assertTrue(form.is_valid())
    
    def test_invalid_value_without_subfieldbase(self):
        form = MyForm(data={u'field_without_subfieldbase':u'bar'})
        self.assertFalse(form.is_valid())

if __name__ == '__main__':
    suite = unittest.TestLoader().loadTestsFromTestCase(TestValidation)
    unittest.TextTestRunner(verbosity=2).run(suite)
