# Django settings for djangops2fix project.
import copy

DEBUG = True
TEMPLATE_DEBUG = DEBUG

ADMINS = (
    # ('Your Name', 'your_email@domain.com'),
)

MANAGERS = ADMINS

'''
Let say we have 2 databases:
default - is our django database which we use for django code
ascii_db - is ASCII database which contains data about some products - this is not django database we just want to get some information from this database.

In some situation we can have this configuration.
Now if we have some stats generator which uses both database,
but in some cases it connect to ASCII database external (not django psycopg2 backends) backends 
we will get Unicode/Integrity error because django registered Unicode Extension and that Extension will try to change all strings to Unicode.

run:

# create some database and run sync
python manage.py syncdb 
# create some ASCII database and run sync
python manage.py syncdb --database ascii_db

# now run test
python manage.py test myapp.MyModelTestCase - will raise UnicodeError for data from ascii_db

but if you just run raw python:
python
>>> from djangops2fix.db import get_custom_data
>>>get_custom_data()

everything is ok,

Try to test it without patch and with it.
http://code.djangoproject.com/attachment/ticket/13161/patch-r12807.diff

In the second case you won't see UnicodeError because we not register global Unicode Extension for psycopg2

'''

# create below database as SQLASCII 
ASCII_DB_CONFIG = {
        'ENGINE': 'django.db.backends.postgresql_psycopg2',
        'NAME': '',
        'USER': '',                      
        'PASSWORD': '',             
        'HOST': '',    
        #'TEST_NAME' : ''
    }

DATABASES = {
    
    'default': {
        'ENGINE': 'django.db.backends.postgresql_psycopg2',
        'NAME': '',                     
        'USER': '',                      
        'PASSWORD': '',             
        'HOST': '',
        #'TEST_NAME' : ''
    }, 
    
    'ascii_db' : ASCII_DB_CONFIG.copy() # need because when we django test change db_name for test database, but we want to use ASCII
}


# Local time zone for this installation. Choices can be found here:
# http://en.wikipedia.org/wiki/List_of_tz_zones_by_name
# although not all choices may be available on all operating systems.
# On Unix systems, a value of None will cause Django to use the same
# timezone as the operating system.
# If running in a Windows environment this must be set to the same as your
# system time zone.
TIME_ZONE = 'America/Chicago'

# Language code for this installation. All choices can be found here:
# http://www.i18nguy.com/unicode/language-identifiers.html
LANGUAGE_CODE = 'en-us'

SITE_ID = 1

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = True

# If you set this to False, Django will not format dates, numbers and
# calendars according to the current locale
USE_L10N = True

# Absolute path to the directory that holds media.
# Example: "/home/media/media.lawrence.com/"
MEDIA_ROOT = ''

# URL that handles the media served from MEDIA_ROOT. Make sure to use a
# trailing slash if there is a path component (optional in other cases).
# Examples: "http://media.lawrence.com", "http://example.com/media/"
MEDIA_URL = ''

# URL prefix for admin media -- CSS, JavaScript and images. Make sure to use a
# trailing slash.
# Examples: "http://foo.com/media/", "/media/".
ADMIN_MEDIA_PREFIX = '/media/'

# Make this unique, and don't share it with anybody.
SECRET_KEY = 'q$@!)pa1g)9y!i=pknc09y!jzss9_@4a4f89*7mn1!$jf=%1=b'

# List of callables that know how to import templates from various sources.
TEMPLATE_LOADERS = (
    'django.template.loaders.filesystem.Loader',
    'django.template.loaders.app_directories.Loader',
#     'django.template.loaders.eggs.Loader',
)

MIDDLEWARE_CLASSES = (
    'django.middleware.common.CommonMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
)

ROOT_URLCONF = 'djangops2fix.urls'

TEMPLATE_DIRS = (
    # Put strings here, like "/home/html/django_templates" or "C:/www/django/templates".
    # Always use forward slashes, even on Windows.
    # Don't forget to use absolute paths, not relative paths.
)

INSTALLED_APPS = (
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.sites',
    'django.contrib.messages',
    # Uncomment the next line to enable the admin:
     'django.contrib.admin',
    # Uncomment the next line to enable admin documentation:
    # 'django.contrib.admindocs',
    'myapp', 
)
