## file: foobar/models.py
from django.db import models
from django.contrib.contenttypes.models import ContentType
from django.contrib.contenttypes import generic

class TaggedItem(models.Model):
    tag = models.SlugField()
    content_type = models.ForeignKey(ContentType)
    object_id = models.PositiveIntegerField()
    content_object = generic.GenericForeignKey('content_type', 'object_id')


class Person(models.Model):
    first_name = models.CharField(max_length=30)
    last_name = models.CharField(max_length=30)


# Before using, make sure that django_content_type contains a row like:
# +----+--------+-----------+--------+
# | id |  name  | app_label | model  |
# +----+--------+-----------+--------+
# |  0 | person | foobar    | person | 
# +----+--------+-----------+--------+
# Do this as follows, after syncdb:
# sql> update django_content_type set id = 0 where app_label="testapp" and model="person";

# # Create a Person:
# In [1]: from foobar.models import TaggedItem, Person
# 
# In [2]: bob = Person(first_name="bob", last_name="bobberson")
# 
# In [3]: bob.save()
# 
# # Tag the person:
# In [4]: tag = TaggedItem(tag="bob tag", content_object=bob)
# 
# In [5]: tag.save()
# 
# # Try to retrieve the person:
# In [6]: fetchtag = TaggedItem.objects.get(id=tag.id)
# 
# # content_object is None?
# In [7]: fetchtag.content_object is None
# Out[7]: True
# 
# # But the object ID is correct...
# In [8]: fetchtag.object_id == bob.id
# Out[8]: True
# 
# # And so is the content_type...
# In [9]: fetchtag.content_type
# Out[9]: <ContentType: person>
# 
# # And we can get the model_class for that content type.
# In [10]: fetchtag.content_type.model_class()
# Out[10]: <class 'foobar.models.Person'>
