# Cases tested:
# - prepop field in inline add another #13608
# - two prepop fields relying on same field #9264
# - prepop based on calendar widget #9784
# - prepop based on dropdown #9983

from django.db import models

class Question(models.Model):
    name = models.CharField(max_length=100)
    pubdate = models.DateField()
    status = models.CharField(max_length=20, choices=(('option one', 'Option One'),
                                                      ('option two', 'Option Two')))
    slug1 = models.SlugField()
    slug2 = models.SlugField()

    parent = models.ForeignKey('self')

from django.contrib import admin

class QuestionInline1(admin.StackedInline):
    model = Question
    extra = 1
    prepopulated_fields = {'slug1': ['name', 'pubdate'],
                           'slug2': ['status', 'name']}

class QuestionInline2(admin.TabularInline):
    model = Question
    extra = 1
    prepopulated_fields = {'slug1': ['name', 'pubdate'],
                           'slug2': ['status', 'name']}

class QuestionAdmin(admin.ModelAdmin):
    inlines = [QuestionInline1, QuestionInline2]
    prepopulated_fields = {'slug1': ['name', 'pubdate'],
                           'slug2': ['status', 'name']}

admin.site.register(Question, QuestionAdmin)
