"""
This file demonstrates two different styles of tests (one doctest and one
unittest). These will both pass when you run "manage.py test".

Replace these with more appropriate tests for your application.
"""

from django.test import TestCase
from django.test.client import Client

class TestThousandSeparatorEnabledInline(TestCase):
    fixtures = ['test_data']

    def setUp(self):
        self.client = Client()
        self.client.login(username='admin', password='test')

    def test_can_save_parent_with_children_with_unformatted_pk(self):
        response = self.client.post('/admin/testapp/parent/1/', {
            'child_set-0-name': 'Child',
            'child_set-MAX_NUM_FORMS': '0',
            'name': 'Parent',
            'child_set-0-id': '12345', # Note: unformatted AutoField.
            'child_set-0-parent': '1',
            'child_set-TOTAL_FORMS': '1',
            'child_set-INITIAL_FORMS': '1'})
        self.assertEqual(response.status_code, 302)

    def test_can_save_parent_with_children_with_formatted_pk(self):
        response = self.client.post('/admin/testapp/parent/1/', {
            'child_set-0-name': 'Child',
            'child_set-MAX_NUM_FORMS': '0',
            'name': 'Parent',
            'child_set-0-id': '12,345', # Note: formatted AutoField.
            'child_set-0-parent': '1',
            'child_set-TOTAL_FORMS': '1',
            'child_set-INITIAL_FORMS': '1'})
        self.assertEqual(response.status_code, 302)

