from unique_test.forms import FirstSubClassForm, SecondSubClassForm
from django.shortcuts import render_to_response
from django.template.context import RequestContext
from django.http import HttpResponseRedirect
from django.core.urlresolvers import reverse

def create_first_subclass(request):
    if request.method == 'POST':
        form = FirstSubClassForm(request.POST)
        if form.is_valid():
            object = form.save()
            return HttpResponseRedirect(reverse('parent_class_list'))
    else:
        form = FirstSubClassForm()

    return render_to_response('create_first_subclass.html',
                              {'form': form},
                              context_instance=RequestContext(request))

def create_second_subclass(request):
    if request.method == 'POST':
        form = SecondSubClassForm(request.POST)
        if form.is_valid():
            object = form.save()
            return HttpResponseRedirect(reverse('parent_class_list'))
    else:
        form = SecondSubClassForm()

    return render_to_response('create_first_subclass.html',
                              {'form': form},
                              context_instance=RequestContext(request))
