from django.test import TestCase
from unique_test.forms import FirstSubClassForm, SecondSubClassForm

"""
Show the use case when unique constraint is raised
while it should be checked by form
"""
class SimpleTest(TestCase):
    def test_inheritance_form_valid_1(self):
        """
        create two instances of FirstSubClass using form
        the first is ok, the second fails, which is what
        we expect
        """
        post = {'name': 'foo', 'attribute1': 'bar'}
        form_first_subclass = FirstSubClassForm(post)
        self.assertTrue(form_first_subclass.is_valid())
        object = form_first_subclass.save()
        self.assertEqual(object.name, 'foo')

        form_first_subclass = FirstSubClassForm(post)
        self.assertFalse(form_first_subclass.is_valid())

    def test_inheritance_form_valid_2(self):
        """"
        create two instances of SecondSubClass using form
        the first is ok, the second fails, which is what
        we expect
        """
        post = {'name': 'foo2', 'attribute2': 'bar2'}
        form_second_subclass = SecondSubClassForm(post)
        self.assertTrue(form_second_subclass.is_valid())
        object = form_second_subclass.save()
        self.assertEqual(object.name, 'foo2')

        form_second_subclass = SecondSubClassForm(post)
        self.assertFalse(form_second_subclass.is_valid())

    def test_inheritance_form_valid_5(self):
        """
        now we create a FirstSubClass instance and a SecondSubClass
        with the same name
        the first is ok, the second should fail validation but it
        doesn't
        """
        post1 = {'name': 'foo', 'attribute1': 'bar1'}
        post2 = {'name': 'foo', 'attribute2': 'bar2'}
        form_first_subclass = FirstSubClassForm(post1)
        self.assertTrue(form_first_subclass.is_valid())
        object = form_first_subclass.save()
        self.assertEqual(object.name, 'foo')

        form_second_subclass = SecondSubClassForm(post2)
        self.assertFalse(form_second_subclass.is_valid())

