from django.conf.urls.defaults import *
from models import Article

info = {
    'queryset': Article.objects.all(),
    'date_field': 'pub_date',
    #'month_format': '%m',
}

urlpatterns = patterns('django.views.generic.date_based',
    (r'^today/$', 'archive_today', info),

    (r'^day_abbrev_month/(?P<year>\d+)/(?P<month>\w+)/(?P<day>\d+)/$',
     'archive_day', dict(info, month_format='%b')),

    (r'^day_num_month/(?P<year>\d+)/(?P<month>\d+)/(?P<day>\d+)/$',
     'archive_day', dict(info, month_format='%m')),
)
