import time
import os
import imp
from django.conf import global_settings, LazySettings, ENVIRONMENT_VARIABLE
from django.utils.importlib import import_module


class Settings(object):
    def __init__(self, settings_module):
        self.set_from_module(global_settings)

        # store the settings module in case someone later cares
        self.SETTINGS_MODULE = settings_module
        
        try:
            project_settings = import_module(self.SETTINGS_MODULE)
        except ImportError, e:
            raise ImportError, "Could not import settings '%s' (Is it on sys.path? Does it have syntax errors?): %s" % (self.SETTINGS_MODULE, e)

        # automatically set defaults from settings in app dir
        for app in getattr(project_settings, 'INSTALLED_APPS', []):
            try:
                app_path = import_module(app).__path__
            except AttributeError:
                continue
            try:
                imp.find_module('settings', app_path)
            except ImportError:
                continue
            app_settings = import_module('%s.settings' % app)
            self.set_from_module(app_settings)
        
        self.set_from_module(project_settings)

        if hasattr(time, 'tzset'):
            # Move the time zone info into os.environ. See ticket #2315 for why
            # we don't do this unconditionally (breaks Windows).
            os.environ['TZ'] = self.TIME_ZONE
            time.tzset()

    def set_from_module(self, mod):
        for setting in dir(mod):
            if setting == setting.upper():
                setattr(self, setting, getattr(mod, setting))

    def get_all_members(self):
        return dir(self)


class LazySettings(LazySettings):
    def _setup(self):
        """
        Load the settings module pointed to by the environment variable. This
        is used the first time we need any settings at all, if the user has not
        previously configured the settings manually.
        """
        try:
            settings_module = os.environ[ENVIRONMENT_VARIABLE]
            if not settings_module: # If it's set but is an empty string.
                raise KeyError
        except KeyError:
            # NOTE: This is arguably an EnvironmentError, but that causes
            # problems with Python's interactive help.
            raise ImportError("Settings cannot be imported, because environment variable %s is undefined." % ENVIRONMENT_VARIABLE)

        self._wrapped = Settings(settings_module)

settings = LazySettings()
