from django.db import models
from django.contrib import admin

class Person(models.Model):
    firstname = models.CharField(max_length=15)
    def __str__(self):
        return self.firstname

class OutfitItem(models.Model):
    name = models.CharField(max_length=15)
    def __str__(self):
        return self.name

class Fashionista(models.Model):
    person = models.OneToOneField(Person, primary_key=True)
    weaknesses = models.ManyToManyField(OutfitItem, through='ShoppingWeakness', blank=True)
    def __str__(self):
        return str(self.person)

class ShoppingWeakness(models.Model):
    fashionista = models.ForeignKey(Fashionista)
    item = models.ForeignKey(OutfitItem)

#Admin

class InlineWeakness(admin.TabularInline):
    model = ShoppingWeakness
    extra = 1

admin.site.register(Fashionista, inlines=[InlineWeakness])
