from django.template import Library, Node, TemplateSyntaxError, Template
from django.template.loader import get_template
from django.conf import settings

#from rexec import RExec


from helpers.url import *	
from helpers.javascript import *	
from helpers.tag import *	
from helpers.prototype import *	
from helpers.scriptaculous import *	
from helpers.form_tag import *	
from helpers.text import *	
from helpers.form_options import *	
from helpers.date import *	
from helpers.number import *	

register = Library()

#@register.tag
def rails(parser, token):
    """
    Ajax helper tags ported from RoR. 

    Usage :
        {% rails function_name (arg1,arg2,kwarg1=3,...) %}

        or
        
        {% rails function_name %}
        arg1,arg2,
        arg3,
        kwarg1=value1,
        kwarg2=value2,
        ...
        {% endrails %}
        
    """
    bits = token.contents.split()    
    if len(bits) < 2:
        raise TemplateSyntaxError, "'rails' tag takes at least one argument: the helper function name"
    if len(bits) == 2:
        # parameter supplied by block 
        nodelist = parser.parse(('endrails',))
        parser.delete_first_token()
        return RailsHelperNode(bits[1], nodelist)
    # parameter supplied by (...) format
    param = ' '.join(bits[2:]).strip()
    if param[0]=='(':
        param = param[1:]
    if param[-1]==')':
        param = param[:-1]
    return RailsHelperNode(bits[1], Template(param))
    
rails = register.tag(rails)

class RailsHelperNode(Node):
    def __init__(self, func_name, nodelist):
        self.func_name = func_name
        self.node_list = nodelist

    def render(self, context):
        if not getattr(self.__module__, self.func_name, 'None'):
            return ''
        param = self.node_list.render(context)
        def argparser(*args, **kws):
            return args, kws
        try:
            exec("args, kws = argparser("+param+")")
        except :
            if settings.DEBUG:
                return "[RailsHelperNode error parsing arguments.]"
            else:
                return ''
        try:
            mod = __import__(self.__module__, '', '', [''])
            if not hasattr(mod, self.func_name):
                if settings.DEBUG:
                    return "no %s in railshelper" % self.func_name
                else:
                    return ''
            return getattr(mod, self.func_name)(*args, **kws)
        except:
            if settings.DEBUG:
                return "[RailsHelperNode error executing function.]"
            else:
                return '' 


def test(*args, **kws):
    return "args=%s, kws=%s" % (args, kws)
