Abstract.DelayedObserver = function(){}
Abstract.DelayedObserver.prototype = {
  initialize: function(element, delay, callback) {
    this.delay = delay;
    this.element   = $(element);
    this.callback  = callback;
    this.timer = -1;
    this.inflight = false;
    this.resubmit = false;

    this.lastValue = this.getValue();
    if (this.element.tagName.toLowerCase() == 'form')
      this.registerFormCallbacks();
    else
      this.registerCallback(this.element);
    window.status = 'initialized';
    return true;
  },
  onElementEvent: function() {
    var value = this.getValue();
    if (this.lastValue != value) {
      if (!this.inflight){
	if(this.timer != -1) clearTimeout(this.timer);
	var _this = this;
	this.timer = setTimeout(function(){_this.submit();}, this.delay*1000);
      } else {
	this.resubmit = true;
      }
    }
    window.status = 'onelementevent';
    return true;
  },
  submit: function(){
    this.timer = -1;
    this.inflight = true;
    this.resubmit = false;
    var value = this.getValue();
    this.callback(this.element, value, this.onload.bind(this), this.onerror.bind(this));
    this.lastValue = value;
    window.status = 'submit';
    return true;
  },
  onload: function(){
    this.inflight = false;
    if (this.resubmit){
      this.resubmit = false;
      this.onElementEvent();
    }
    window.status = 'onload';
    return true;
  },
  onerror: function(){
    this.inflight = false;
    this.resubmit = false;
    window.status = 'onerror';
    return true;
  },
  registerFormCallbacks: function() {
    var elements = Form.getElements(this.element);
    for (var i = 0; i < elements.length; i++)
      this.registerCallback(elements[i]);
  },

  registerCallback: function(element) {
    if (element.type) {
      switch (element.type.toLowerCase()) {
        case 'checkbox':
        case 'radio':
          Event.observe(element, 'click', this.onElementEvent.bind(this));
          break;
        case 'password':
        case 'text':
        case 'textarea':
          Event.observe(element, 'keyup', this.onElementEvent.bind(this));
        case 'select-one':
        case 'select-multiple':
          Event.observe(element, 'change', this.onElementEvent.bind(this));
          Event.observe(element, 'mouseup', this.onElementEvent.bind(this));
          break;
      }
    }
  }
}

Form.Element.DelayedObserver = Class.create();
Form.Element.DelayedObserver.prototype = Object.extend(new Abstract.DelayedObserver(), {
  getValue: function() {
    return Form.Element.getValue(this.element);
  }
});

Form.DelayedObserver = Class.create();
Form.DelayedObserver.prototype = Object.extend(new Abstract.DelayedObserver(), {
  getValue: function() {
    return Form.serialize(this.element);
  }
});
