import sys, os, time

# This dictionary maps Field objects to their associated PostgreSQL column
# types, as strings. Column-type strings can contain format strings; they'll
# be interpolated against the values of Field.__dict__ before being output.
# If a column type is set to None, it won't be included in the output.

DATA_TYPES = {
    'AutoField':                     'INTEGER',
    'BooleanField':                  'SMALLINT',
    'CharField':                     'VARCHAR(%(maxlength)s)',
    'CommaSeparatedIntegerField':    'VARCHAR(%(maxlength)s)',
    'DateField':                     'DATE',
    'DateTimeField':                 'TIMESTAMP',
    'FileField':                     'VARCHAR(100)',
    'FilePathField':                 'VARCHAR(100)',
    'FloatField':                    'NUMERIC(%(max_digits)s, %(decimal_places)s)',
    'ImageField':                    'VARCHAR(100)',
    'IntegerField':                  'INTEGER',
    'IPAddressField':                'VARCHAR(15)',
    'ManyToManyField':               None,
    'NullBooleanField':              'SMALLINT',
    'OneToOneField':                 'INTEGER',
    'PhoneNumberField':              'VARCHAR(20)',
    'PositiveIntegerField':          'INTEGER',
    'PositiveSmallIntegerField':     'SMALLINT',
    'SlugField':                     'VARCHAR(%(maxlength)s)',
    'SmallIntegerField':             'SMALLINT',
    'TextField':                     'BLOB SUB_TYPE 1',
    'TimeField':                     'TIME',
    'URLField':                      'VARCHAR(200)',
    'USStateField':                  'VARCHAR(2)',
}

TEST_DATABASE_PREFIX = 'test_'

def create_test_db(settings, connection, backend, verbosity, autoclobber):
    if verbosity >= 1:
        print "Creating test database..."

    if settings.TEST_DATABASE_NAME:
        TEST_DATABASE_NAME = settings.TEST_DATABASE_NAME
    else:
        TEST_DATABASE_NAME = settings.DATABASE_NAME
    TEST_DATABASE_NAME = os.path.join(
        os.path.dirname(settings.DATABASE_NAME),
        TEST_DATABASE_PREFIX + TEST_DATABASE_NAME)

    settings.DATABASE_NAME = TEST_DATABASE_NAME

    try:
        _create_test_db(backend, settings)
    except Exception, e:
        sys.stderr.write("Got an error creating the test database: %s\n" % e)
        if not autoclobber:
            confirm = raw_input("It appears the test database, %s, already exists. Type 'yes' to delete it, or 'no' to cancel: " % TEST_DATABASE_NAME)
        if autoclobber or confirm == 'yes':
            try:
                if verbosity >= 1:
                    print "Destroying old test database..."
                _destroy_test_db(connection)
                if verbosity >= 1:
                    print "Creating test database..."
                _create_test_db(backend, settings)
            except Exception, e:
                sys.stderr.write("Got an error recreating the test database: %s\n" % e)
                sys.exit(2)
        else:
            print "Tests cancelled."
            sys.exit(1)

    #connection.close()
    #connection.cursor()

def destroy_test_db(settings, connection, backend, old_database_name, verbosity):
    if verbosity >= 1:
        print "Destroying test database..."

    _destroy_test_db(connection)
    #connection.close()

    TEST_DATABASE_NAME = settings.DATABASE_NAME
    settings.DATABASE_NAME = old_database_name

def _create_test_db(backend,settings):
    conn = backend.Database.create_database("CREATE DATABASE '%s' user '%s' password '%s'" % \
        (settings.DATABASE_NAME, settings.DATABASE_USER, settings.DATABASE_PASSWORD))
    cursor = conn.cursor()
    cursor.execute("""
    DECLARE EXTERNAL FUNCTION rand
        RETURNS DOUBLE PRECISION
        BY VALUE ENTRY_POINT 'IB_UDF_rand' MODULE_NAME 'ib_udf';
    """)
    conn.commit()
    conn.close()

def _destroy_test_db(connection):
    return
    connection.cursor()
    connection._drop_database()