from django.db.backends.firebird.base import quote_name
#from django.core.management import style

def create_sequence_sql(table_name, field_name):
    output = []
    sequence_name = "%s_%s_seq" % (table_name, field_name)
    # CREATE SEQUENCE for Firebird 2
    sequence_statement = 'CREATE GENERATOR %s;\n' % quote_name(sequence_name)
    output.append(sequence_statement)
    trigger_name = "%s_%s_ai" % (table_name, field_name)
    trigger_statement = "" + \
        "CREATE TRIGGER %s FOR %s\n" % (quote_name(trigger_name), quote_name(table_name)) + \
        "    ACTIVE BEFORE INSERT POSITION 0\n" + \
        "    AS\n" + \
        "    BEGIN\n" + \
        "    if ((NEW.%s IS NULL) OR (NEW.%s = 0)) THEN\n" % (quote_name(field_name), quote_name(field_name)) + \
        "    BEGIN\n" + \
        "        NEW.%s = GEN_ID(%s, 1);\n" % (quote_name(field_name), quote_name(sequence_name)) + \
        "    END\n" + \
        "END\n"
    output.append(trigger_statement)
    return output

# This dictionary maps Field objects to their associated PostgreSQL column
# types, as strings. Column-type strings can contain format strings; they'll
# be interpolated against the values of Field.__dict__ before being output.
# If a column type is set to None, it won't be included in the output.

DATA_TYPES = {
    'AutoField':         'integer',
    'BooleanField':      'smallint',
    'CharField':         'varchar(%(maxlength)s)',
    'CommaSeparatedIntegerField': 'varchar(%(maxlength)s)',
    'DateField':         'date',
    'DateTimeField':     'timestamp',
    'FileField':         'varchar(100)',
    'FilePathField':     'varchar(100)',
    'FloatField':        'numeric(%(max_digits)s, %(decimal_places)s)',
    'ImageField':        'varchar(100)',
    'IntegerField':      'integer',
    'IPAddressField':    'varchar(15)',
    'ManyToManyField':   None,
    'NullBooleanField':  'smallint',
    'OneToOneField':     'integer',
    'PhoneNumberField':  'varchar(20)',
    'PositiveIntegerField': 'integer',
    'PositiveSmallIntegerField': 'smallint',
    'SlugField':         'varchar(%(maxlength)s)',
    'SmallIntegerField': 'smallint',
    'TextField':         'blob SUB_TYPE 1',
    'TimeField':         'time',
    'URLField':          'varchar(200)',
    'USStateField':      'varchar(2)',
}