from django.contrib import admin
from django.contrib.auth.models import User

from models import Account, Membership

class MembershipInline(admin.TabularInline):
    model = Membership

class AccountAdmin(admin.ModelAdmin):
    model = Account
    inlines = [
        MembershipInline,
    ]

admin.site.register(Account, AccountAdmin)