from django.contrib.auth.models import User
from django.db import models

class Account(models.Model):
    name = models.CharField(max_length=100)
    logo = models.ImageField(upload_to='logo')
    users = models.ManyToManyField(User, through='Membership')

class Membership(models.Model):
    user = models.ForeignKey(User)
    account = models.ForeignKey(Account)