'''
Demonstrate select_related feature
Created on Dec 21, 2009

@author: jtiai
'''

from django.db import models
from custom import *

class CustomModel(models.Model):
    """
    Custom model that uses special CustomManager that makes all CharField
    based fields to uppercase.
    """
    
    name = models.CharField(max_length=64)
    num = models.IntegerField(null=True, blank=True)
    
    objects = CustomManager()
    
    class Meta:
        db_table = "CUSTOM_MODEL"
        
    def __unicode__(self):
        return u'Custom model: %s' % self.name

class StandardModel(models.Model):
    """
    Standard Django model that has foreign key to CustomModel
    """
    name = models.CharField(max_length=64)
    custom_model = models.ForeignKey(CustomModel)
    objects = models.Manager()

    class Meta:
        db_table = 'STANDARD_MODEL'
    
    def __unicode__(self):
        return u'Standard model: %s' % self.name
    