from django.db import models
# Create your models here.
from custom import *

class CustomModel(models.Model):
    """
    Custom model that uses special CustomManager that makes all CharField
    based fields to uppercase.
    """
    
    name = models.CharField(max_length=64)
    num = models.IntegerField(null=True, blank=True)
    
    objects = CustomManager()
    
    class Meta:
        db_table = "CUSTOM_MODEL"
        
    def __unicode__(self):
        return u'Custom model: %s' % self.name

class StandardModel(models.Model):
    """
    Standard Django model that has foreign key to CustomModel
    """
    name = models.CharField(max_length=64)
    custom_model = models.ForeignKey(CustomModel)

    class Meta:
        db_table = 'STANDARD_MODEL'
    
    def __unicode__(self):
        return u'Standard model: %s' % self.name
    