from django.db.models import Manager
from django.db.models.query import QuerySet
from django.db.models.sql import Query

class CustomQuery(Query):
    compiler = 'CustomSQLCompiler'
    
class CustomQuerySet(QuerySet):
    ### Methods overloaded from QuerySet ###
    def __init__(self, model=None, query=None, using=None):
        super(CustomQuerySet, self).__init__(model=model, query=query)
        self.query = query or CustomQuery(self.model)

class CustomManager(Manager):
    def get_query_set(self):
        qs = CustomQuerySet(self.model)
        if self._db is not None:
            qs = qs.using(self._db)
        return qs