#Idea and implementation by Anton Berezin

from django.http import HttpResponse, HttpRequest
from django.template import loader
from django.template import RequestContext
import re #regexp


#The response object that can hold the context
class HttpResponseHolder(HttpResponse):
    context = {} #make sure that it is a dictianory


#Adds a template to a view, uses context processors
class template(object):

    def __init__(self, template_name = None):
        self.template_name = template_name

    def __call__(self, function):
        def function_wrapper(request, *args, **kwargs):
            return_val = function(request, *args, **kwargs)
            #get a proper template name
            if self.template_name == None: #if template name is not defined derive it from package name and view function name
                array = re.split("\.", function.__module__) #split into array with elements like [0]=project_name, [1]=package_name, [2]=file_name (where the function lives)
                package_name = array[1]
                self.template_name = "%s/%s.html" %(package_name, function.__name__)
            #compose the response
            template = loader.get_template(str(self.template_name))
            if isinstance(return_val, HttpResponseHolder):
                return HttpResponse(template.render(RequestContext(request, return_val.context)))
            elif isinstance(return_val, dict):
                return HttpResponse(template.render(RequestContext(request, return_val)))
            elif isinstance(return_val, HttpResponse):
                return return_val
            else:
                return
        return function_wrapper
