class ForeignKey:
    fkeys_to_name = {}  # Keyed by object's id
    def __init__(self, otherclass):
        self.otherclass = otherclass
        self.default_name = self.otherclass.__name__.lower()
        self.name = None  # Will be set later

        # Keep a reference to this instance around
        ForeignKey.fkeys_to_name[id(self)] = self

class ModelBase(type):
    # Metaclass for Model objects
    def __new__(cls, name, bases, attrs):
        if not bases:
            return type.__new__(cls, name, bases, attrs)
        new_class = type.__new__(cls, name, bases, attrs)
        for name, obj in attrs.items():
            if isinstance(obj, ForeignKey):
                obj.name = name
                del ForeignKey.fkeys_to_name[id(obj)]
        # Now all named ForeignKeys are gone, only unnamed ones remain
        for fkey in ForeignKey.fkeys_to_name.values():
            fkey.name = fkey.default_name
            setattr(new_class, fkey.name, fkey)
        ForeignKey.fkeys_to_name = {}  # Reset for next class
        return new_class

class Model:
    __metaclass__ = ModelBase

class One(Model):
    pass

class Two(Model):
    pass

class SampleRecord(Model):
    ForeignKey(One)
    ForeignKey(Two)

if __name__ == '__main__':
    for name, val in SampleRecord.__dict__.items():
        print name, '=', val
        if isinstance(val, ForeignKey):
            print val, 'knows its name is', val.name
