#!/usr/bin/env python

import sys
from django.conf import settings
settings.configure(
    DATABASE_ENGINE='sqlite3',
    DATABASE_NAME=':memory:',
    INSTALLED_APPS=('test_models',),
    DEBUG = True
)

from django.db import connection
from test_models.models import TestModel

def main():
    db_name = connection.creation.create_test_db()
    
    a = TestModel()
    a.save()
    a.clean()
    print connection.queries[-1]

    connection.creation.destroy_test_db(db_name)

if __name__ == '__main__':
    sys.exit(main())