diff --git a/django/contrib/admin/sites.py b/django/contrib/admin/sites.py
index c1f6970..870ab04 100644
--- a/django/contrib/admin/sites.py
+++ b/django/contrib/admin/sites.py
@@ -61,6 +61,8 @@ class AdminSite(object):
         they'll be applied as options to the admin class.
 
         If a model is already registered, this will raise AlreadyRegistered.
+        
+        If a model is abstract, this will raise ImproperlyConfigured.
         """
         if not admin_class:
             admin_class = ModelAdmin
@@ -74,6 +76,10 @@ class AdminSite(object):
         if isinstance(model_or_iterable, ModelBase):
             model_or_iterable = [model_or_iterable]
         for model in model_or_iterable:
+            if model._meta.abstract:
+                raise ImproperlyConfigured('The model %s is abstract and '
+                      'therefore cannot be registered' % model.__name__)
+
             if model in self._registry:
                 raise AlreadyRegistered('The model %s is already registered' % model.__name__)
 
diff --git a/tests/regressiontests/admin_views/models.py b/tests/regressiontests/admin_views/models.py
index 9ac99cc..bd3b956 100644
--- a/tests/regressiontests/admin_views/models.py
+++ b/tests/regressiontests/admin_views/models.py
@@ -641,8 +641,13 @@ class CyclicTwo(models.Model):
 class Topping(models.Model):
     name = models.CharField(max_length=20)
 
-class Pizza(models.Model):
+class AbstractPizza(models.Model):
     name = models.CharField(max_length=20)
+
+    class Meta:
+        abstract = True
+
+class Pizza(AbstractPizza):
     toppings = models.ManyToManyField('Topping')
 
 class PizzaAdmin(admin.ModelAdmin):
diff --git a/tests/regressiontests/admin_views/tests.py b/tests/regressiontests/admin_views/tests.py
index bbef907..a5cf305 100644
--- a/tests/regressiontests/admin_views/tests.py
+++ b/tests/regressiontests/admin_views/tests.py
@@ -6,7 +6,7 @@ import urlparse
 
 from django.conf import settings
 from django.core import mail
-from django.core.exceptions import SuspiciousOperation
+from django.core.exceptions import SuspiciousOperation, ImproperlyConfigured
 from django.core.files import temp as tempfile
 from django.core.urlresolvers import reverse
 # Register auth models with the admin.
@@ -36,7 +36,7 @@ from models import (Article, BarAccount, CustomArticle, EmptyModel,
     Language, Collector, Widget, Grommet, DooHickey, FancyDoodad, Whatsit,
     Category, Post, Plot, FunkyTag, Chapter, Book, Promo, WorkHour, Employee,
     Question, Answer, Inquisition, Actor, FoodDelivery,
-    RowLevelChangePermissionModel, Paper, CoverLetter)
+    RowLevelChangePermissionModel, Paper, CoverLetter, AbstractPizza)
 
 
 class AdminViewBasicTest(TestCase):
@@ -530,6 +530,19 @@ class CustomModelAdminTest(AdminViewBasicTest):
         response = self.client.get('/test_admin/%s/my_view/' % self.urlbit)
         self.assert_(response.content == "Django is a magical pony!", response.content)
 
+class AdminRegistrationTest(TestCase):
+
+    def testAbstractModel(self):
+        """
+        Exception is raised when trying to register an abstract model.
+        Refs #12004.
+        """
+        from django.contrib.admin import site
+        # Smoke test to determine whether admin site works at all
+        response = self.client.get('/test_admin/admin/admin_views/pizza/')
+        self.failUnlessEqual(response.status_code, 200)
+        self.assertRaises(ImproperlyConfigured, site.register, AbstractPizza)
+
 def get_perm(Model, perm):
     """Return the permission object, for the Model"""
     ct = ContentType.objects.get_for_model(Model)
