class SimpleModel(models.Model):
    user = models.ForeignKey(User, to_field="username")

class ComplexModel(models.Model):
    relations = models.ManyToManyField(User, through='IntermediateModel')

class IntermediateModel(models.Model):
    user = models.ForeignKey(User, to_field="username")
    other = models.ForeignKey(M2MToField)

class toFieldTests(unittest.TestCase):
    def setUp(self):
        self.user = User.objects.create(email="username@sample.com",username="username")
    
    def tearDown(self):
        self.user.delete()
        
    class testRelational(self):
        instance = ComplexModel.objects.create()
        
        IntermediateModel.objects.create(other=instance, user=self.user)
        
        # Fails
        self.assertEquals(list(instance.relations.all()), [self.user])
        
    class testSimple(self):
        instance = SimpleModel.objects.create(user=self.user)

        self.assertEquals(instance.user, self.user)

        # Fails
        self.assertEquals(SimpleModel.objects.get(user=self.user), instance)
