from django.contrib import admin

admin.site.apps = [
    {
        'name': 'User Management',
        'classes': 'collapse-closed',
        'show_apps': True,
        'apps': ['auth', 'user', 'registration']
    },
    {
        'name': 'Main Content',
        'classes': 'collapse-closed',
        'show_apps': True,
        'apps': ['movies', 'stars']
    },
    {
        'name': 'Special Content',
        'classes': 'collapse-closed',
        'show_apps': False,
        'apps': ['festivals']
    },
    ...
]

from www.movies.models import Movie, MovieTip
from www.movies.admin import MovieOptions, MovieTipOptions

from www.stars.models import Star, StarNews, StarInterview, StarCredit
from www.stars.admin import StarOptions, StarNewsOptions, StarInterviewOptions, StarCreditOptions

from www.trailer.models import Trailer, TrailerItem, TrailerMobile
from www.trailer.admin import TrailerOptions, TrailerMobileOptions

from www.gallery.models import Gallery, GalleryItem
from www.gallery.admin import GalleryOptions

from www.festivals.models import SpecialScreening, SpecialScreeningSet, SpecialScreeningSetItem
from www.festivals.models import Award, AwardSet, AwardSetItem
from www.festivals.models import Festival, FestivalSet, FestivalSetItem
from www.festivals.admin import SpecialScreeningOptions, SpecialScreeningSetOptions, AwardOptions, AwardSetOptions, FestivalOptions, FestivalSetOptions

main_site = admin.AdminSite()
main_site.register(Movie, MovieOptions)
main_site.register(MovieTip, MovieTipOptions)
main_site.register(Star, StarOptions)
main_site.register(StarNews, StarNewsOptions)
main_site.register(StarInterview, StarInterviewOptions)
main_site.register(StarCredit, StarCreditOptions)
main_site.register(Trailer, TrailerOptions)
main_site.register(TrailerMobile, TrailerMobileOptions)
main_site.register(Gallery, GalleryOptions)
main_site.register(SpecialScreening, SpecialScreeningOptions)
main_site.register(SpecialScreeningSet, SpecialScreeningSetOptions)
main_site.register(Award, AwardOptions)
main_site.register(AwardSet, AwardSetOptions)
main_site.register(Festival, FestivalOptions)
main_site.register(FestivalSet, FestivalSetOptions)

main_site.apps = [
    {
        'name': 'Main Content',
        'classes': '',
        'show_apps': True,
        'apps': ['movies', 'stars']
    },
    {
        'name': 'Special Content',
        'classes': '',
        'show_apps': False,
        'apps': ['festivals']
    },
    {
        'name': 'Relational Content',
        'classes': '',
        'show_apps': True,
        'apps': ['trailer', 'gallery']
    }
]
