def results_iter(self):
        """
        Returns an iterator over the results from executing this query.
        """
        resolve_columns = hasattr(self, 'resolve_columns')
        fields = None
        
        if self.aggregate_select:
            aggregate_start = len(self.extra_select.keys())
            only_load = self.deferred_to_columns()
            for col in self.select:
                if isinstance(col, (list, tuple)):
                    alias, column = col
                    table = self.alias_map[alias][TABLE_NAME]
                    if table not in only_load or column in only_load[table]:
                        aggregate_start += 1
            aggregate_end = aggregate_start + len(self.aggregate_select)
            
        for rows in self.execute_sql(MULTI):
            for row in rows:
                if resolve_columns:
                    if fields is None:
                        # We only set this up here because
                        # related_select_fields isn't populated until
                        # execute_sql() has been called.
                        if self.select_fields:
                            fields = self.select_fields + self.related_select_fields
                        else:
                            fields = self.model._meta.fields
                    row = self.resolve_columns(row, fields)

                if self.aggregate_select:    
                    row = tuple(row[:aggregate_start]) + tuple([
                        self.resolve_aggregate(value, aggregate)
                        for (alias, aggregate), value
                        in zip(self.aggregate_select.items(), row[aggregate_start:aggregate_end])
                    ]) + tuple(row[aggregate_end:])
                yield row
