import re, time

test_string="Hello, I'm a simple string we're going to use. \\ - ; &"
iterations=50000

###################old implementation##################
_base_js_escapes = (
    ('\\', r'\x5C'),
    ('\'', r'\x27'),
    ('"', r'\x22'),
    ('>', r'\x3E'),
    ('<', r'\x3C'),
    ('&', r'\x26'),
    ('=', r'\x3D'),
    ('-', r'\x2D'),
    (';', r'\x3B')
)

# Escape every ASCII character with a value less than 32.
_js_escapes = (_base_js_escapes +
               tuple([('%c' % z, '\\x%02X' % z) for z in range(32)]))

def escapejs(value):
    for bad, good in _js_escapes:
        value = value.replace(bad, good)
    return value
#######################################################
    
#time old implementation
t1=time.time()
for x in range(iterations):
    escapejs(test_string)
t2=time.time()
print 'old implementation took %0.3f ms' % ((t2-t1)*1000.0)
print 'value calculated: %s' % escapejs(test_string)

#####################new implementation################
_base_js_escapes = (
    ('\\', r'\x5C'),
    ('\'', r'\x27'),
    ('"', r'\x22'),
    ('>', r'\x3E'),
    ('<', r'\x3C'),
    ('&', r'\x26'),
    ('=', r'\x3D'),
    ('-', r'\x2D'),
    (';', r'\x3B')
)

# Escape every ASCII character with a value less than 32.
_js_escapes = (_base_js_escapes +
               tuple([('%c' % z, '\\x%02X' % z) for z in range(32)]))

_js_escapes_dict={}
for k, v in _js_escapes:
    _js_escapes_dict[k]=v

_js_escapes_re = re.compile(u'[\u0000-\u001f]|\\\\|\'|"|>|<|&|=|-|;')

def escapejs_new(value):
    return _js_escapes_re.sub(lambda m: _js_escapes_dict[m.group(0)], value)
#######################################################


#time new implementation
t1=time.time()
for x in range(iterations):
    escapejs_new(test_string)
t2=time.time()
print 'new implementation took %0.3f ms' % ((t2-t1)*1000.0)
print 'value calculated: %s' % escapejs_new(test_string)