class Item(models.Model):
    item_type = models.CharField(choices=ITEMS, max_length=50)
    search_data = models.CharField('Searchable data',
                                   max_length=search_data_size,
                                   blank=True, 
                                   db_index=True,
                                   help_text='The data that will be indexed for search')

    raw_title = models.CharField(max_length=550,
                             blank=True,
                             help_text='The canonical title for this Item')
    
    title = models.CharField(max_length=255, db_index=True, blank=True)
    prefix = models.CharField(max_length=20, blank=True)
    subtitle = models.CharField(blank=True, max_length=255)

    

    # who owns this item?
    owners = models.ManyToManyField(Member, null=True, through='LibraryItem', related_name="library_items")

    # interface objects when dealing with amazon items mixed in with local items
    amazon_item = False
    amazon_editions = []

    # meta
    slug = models.SlugField(max_length=255, blank=True, unique=False)
    date_added = models.DateTimeField(auto_now_add=True, editable=False)
    date_updated = models.DateTimeField(auto_now=True, editable=False)
    added_by = models.ForeignKey(Member, blank=True, null=True, related_name="items_added")