import os
from django.core.management.base import NoArgsCommand
from optparse import make_option

class Command(NoArgsCommand):
    option_list = NoArgsCommand.option_list + (
        make_option('--plain', action='store_true', dest='plain',
            help='Tells Django to use plain Python, not IPython.'),
        make_option('--bpython', action='store_true', dest='bpython',
            help='Tells Django to use bpython, not IPython.'),
    )
    help = "Runs a Python interactive interpreter. Tries to use IPython, if it's available.  If IPython is not available, tries to use bpython. "

    requires_model_validation = False

    def handle_noargs(self, **options):
        # XXX: (Temporary) workaround for ticket #1796: force early loading of all
        # models from installed apps.
        from django.db.models.loading import get_models
        loaded_models = get_models()

        use_plain = options.get('plain', False)
	use_bpython = options.get('bpython',False)
        try:
            if use_plain or use_bpython:
                if use_bpython:
                    use_plain = None
                raise ImportError
            import IPython
            shell = IPython.Shell.IPShell(argv=[])
            shell.mainloop()
        except ImportError:
            try:
                if use_plain:
                    raise ImportError
                import bpython
                try:
                    bpython.embed()
                except AttributeError:
                    if use_bpython:
                        raise AttributeError("Your version of bpython does not support embedding.  Please upgrade to the latest version.")
                    else:
                        raise ImportError
            except ImportError:
                import code
                # Set up a dictionary to serve as the environment for the shell, so
                # that tab completion works on objects that are imported at runtime.
                # See ticket 5082.
                imported_objects = {}
                try: # Try activating rlcompleter, because it's handy.
                    import readline
                except ImportError:
                    pass
                else:
                    # We don't have to wrap the following import in a 'try', because
                    # we already know 'readline' was imported successfully.
                    import rlcompleter
                    readline.set_completer(rlcompleter.Completer(imported_objects).complete)
                    readline.parse_and_bind("tab:complete")

                # We want to honor both $PYTHONSTARTUP and .pythonrc.py, so follow system
                # conventions and get $PYTHONSTARTUP first then import user.
                if not use_plain:
                    pythonrc = os.environ.get("PYTHONSTARTUP")
                    if pythonrc and os.path.isfile(pythonrc):
                        try:
                            execfile(pythonrc)
                        except NameError:
                            pass
                # This will import .pythonrc.py as a side-effect
                    import user
                code.interact(local=imported_objects)

