# -*- coding: utf-8 -*-
# Tests for the contrib/localflavor/ IL Form Fields

tests = r"""
# CZPostalCodeField #########################################################

>>> from django.contrib.localflavor.il.forms import ILPostalCodeField
>>> f = ILPostalCodeField()
>>> f.clean('84545x')
Traceback (most recent call last):
...
ValidationError: [u'Enter a postal code in the format XXXXX']
>>> f.clean('69973')
u'69973'
>>> f.clean('699 73')
u'69973'
>>> f.clean('12345')
u'12345'
>>> f.clean('123456')
Traceback (most recent call last):
...
ValidationError: [u'Enter a postal code in the format XXXXX']
>>> f.clean('1234')
Traceback (most recent call last):
...
ValidationError: [u'Enter a postal code in the format XXXXX']
>>> f.clean('123 4')
Traceback (most recent call last):
...
ValidationError: [u'Enter a postal code in the format XXXXX']

# ILIDNumberField ########################################################

>>> from django.contrib.localflavor.il.forms import ILIDNumberField
>>> f = ILIDNumberField()
>>> f.clean('39337423')
u'39337423'
>>> f.clean('039337423')
u'039337423'
>>> f.clean('0091')
u'0091'
>>> f.clean('123465789')
Traceback (most recent call last):
...
ValidationError: [u'Enter a valid ID number.']
>>> f.clean('012346578')
Traceback (most recent call last):
...
ValidationError: [u'Enter a valid ID number.']
>>> f.clean('0001')
Traceback (most recent call last):
...
ValidationError: [u'Enter a valid ID number.']
"""
