from django.test import TestCase

from django.db import models
from django.core.paginator import Paginator,NBPageList
from models import Model1
import random

class SimpleTest(TestCase):
    def setUp(self):
        for i in range(10):
            m = Model1()
            m.name = random.random()*3000
            m.save()
    def test_basic_addition(self):
        objs = NBPageList(Model1.objects)
        p = Paginator(objs, 5)
        self.assertEqual( p.count,10 )
        self.assertEqual( p.num_pages,2 )
        self.assertEqual( p.page_range,[1,2] )
        page1 = p.page(1)
        print page1
        print page1.object_list
        page2 = p.page(2)
        print page2
        print page2.object_list
        self.assertEqual( page2.has_next(),False )
        self.assertEqual( page2.has_previous(),True )
        self.assertEqual( page1.has_next(),True )

