from django.db import models

class Article(models.Model):
    headline = models.CharField(max_length=100, default='Default headline')
    pub_date = models.DateTimeField()

    def __unicode__(self):
        return self.headline

__test__ = {'API_TESTS': """
>>> from datetime import datetime
>>> a = Article(id=None, headline='Outside of a dog, a book is Man''s best friend', pub_date=datetime(2005, 7, 28))
>>> a.save()
>>> a2 = Article(id=None, headline='and inside of a dog, it''s too dark to read',  pub_date=datetime(2006,7,28))
>>> a2.save()

# The latest id should be 2
>>> Article.objects.latest('id').id
2

# The latest id is still 2, even if we sorted the queryset first.
>>> Article.objects.order_by('id').latest('id').id
2

"""}

