import django.forms as forms

from django.contrib import admin

from models import Location
from models import Route


class LocationForm(forms.ModelForm):
    latitude = forms.FloatField(widget=forms.HiddenInput)


class LocationInline(admin.TabularInline):
    model = Location
    form = LocationForm
    extra = 1


class RouteAdmin(admin.ModelAdmin):
    inlines = [
        LocationInline,
        ]


admin.site.register(Route, RouteAdmin)
