from django.db import models
from django.contrib.auth.models import User
from datetime import date

class PerformanceGroup(models.Model):
    "Any sort of performance group, such as an a cappella group, a dance troupe, theater group, etc."
    college = models.ForeignKey(College)
    name = models.CharField(max_length=50, verbose_name="group name")
    style = models.CharField(max_length=50, help_text="A theme or idea that characterizes this group.", blank=True)
    description = models.TextField()
    members = models.ManyToManyField(User, through='PerformanceGroupMembership')
    date_founded = models.DateField(help_text="May be an approximate date.")
    email = models.EmailField(blank=True)
    external_site = models.URLField(blank=True)
    tags = TagField(blank=True)
    
    def __unicode__(self):
        return self.name

class PerformanceGroupMembership(models.Model):
    "A member of a PerformanceGroup. Maintains current members (date_left is blank) as well as alumni (date_left has a value)."
    user = models.ForeignKey(User)
    performance_group = models.ForeignKey(PerformanceGroup)
    date_joined = models.DateField() #default=date.today.__str__)
    date_left = models.DateField(blank=True, default='')
    title = models.CharField(max_length=50, blank=True, default='')