try:
    from cStringIO import StringIO
except ImportError:
    from StringIO import StringIO
    
from django.core.files.uploadhandler import FileUploadHandler, SkipFile, StopUpload, StopFutureHandlers
import ImageFile

IMAGE_MAX_SIZE = 1024*1024

class ImageFileUploadHandler(FileUploadHandler):
    def handle_raw_input(self, input_data, META, content_length, boundary, encoding=None):
        print "<IFUH>: Got new file of size: ", content_length
        
        if content_length > IMAGE_MAX_SIZE:
            print "<IFUH>: And it exceeds ", IMAGE_MAX_SIZE
            raise SkipFile

    def new_file(self, *args, **kwargs):
        super(ImageFileUploadHandler, self).new_file(*args, **kwargs)
        
        print "<IFUH>: Started new upload."
        self.file = ImageFile.Parser()
        raise StopFutureHandlers()

    def receive_data_chunk(self, raw_data, start):
        print "<IFUH>: Got new data chunk.", start, start+len(raw_data)
        if start+len(raw_data) > IMAGE_MAX_SIZE:
            print "<IFUH>: Image exceeds ", IMAGE_MAX_SIZE
            raise StopUpload
        try:
            self.file.feed(raw_data)
            print "<IFUH>: It seems all right."
        except IOError:
            print "<IFUH>: It's not all right."
            raise StopUpload
        
        return None

    def file_complete(self, file_size):
        print "<IFUH>: Upload completed."
        try:
            self.file = self.file.close()
            print "<IFUH>: Valid image upload completed."
        except IOError:
            print "<IFUH>: Image upload completed, it's not valid."
            return None
        
        return self.file