from django.db import models
from django.contrib.auth.models import User
from django.contrib.localflavor.us.models import USStateField, PhoneNumberField

class Place(models.Model):
	name = models.CharField(max_length=34)
	address = models.CharField(max_length=80)
	city = models.CharField(max_length=30)
	state = USStateField()
	creator = models.ForeignKey(User)
	phone_number = PhoneNumberField(blank=True)
	website = models.URLField(verify_exists=True, blank=True)
	description = models.TextField(blank=True)
	
	creation_date = models.DateTimeField(auto_now_add=True)
	
	monday_start = models.TimeField(blank=True, null=True)
	monday_end = models.TimeField(blank=True, null=True)
	tuesday_start = models.TimeField(blank=True, null=True)
	tuesday_end = models.TimeField(blank=True, null=True)
	wednesday_start = models.TimeField(blank=True, null=True)
	wednesday_end = models.TimeField(blank=True, null=True)
	thursday_start = models.TimeField(blank=True, null=True)
	thursday_end = models.TimeField(blank=True, null=True)
	friday_start = models.TimeField(blank=True, null=True)
	friday_end = models.TimeField(blank=True, null=True)
	saturday_start = models.TimeField(blank=True, null=True)
	saturday_end = models.TimeField(blank=True, null=True)
	sunday_start = models.TimeField(blank=True, null=True)
	sunday_end = models.TimeField(blank=True, null=True)
